/*
 *
 *  A canvas to PDF converter. Uses a mock canvas context to build a PDF document.
 *
 *  Licensed under the MIT license:
 *  http://www.opensource.org/licenses/mit-license.php
 *
 *  Author:
 *  Joshua Gould
 *
 *  @license Copyright (c) 2017 Joshua Gould
*/
!function(t){"use strict";var e=void 0!==e?e:{};t.canvas2pdf=e;const o=new Set,i={},n=[];function r(t,e,o,i){t=t%360+360*(t<0);var n=o+(o<.5?o:1-o)*(e=isNaN(t)||isNaN(e)?0:e),r=2*o-n;return m(s(t>=240?t-240:t+120,r,n),s(t,r,n),s(t<120?t+240:t-120,r,n),i)}function s(t,e,o){return 255*(t<60?e+(o-e)*t/60:t<180?o:t<240?e+(o-e)*(240-t)/60:e)}e.setFontPath=function(t){e.fontPath=t},e.runAfterFontsLoaded=function(t){try{t()}catch(e){console.log("will retry after fonts loaded: "+e),n.push(t)}},e.addFonts=function(t){if(Object.assign(i,t),Object.keys(t).forEach((t=>o.delete(t))),!o.size){const t=[...n];n.splice(0),t.forEach(e.runAfterFontsLoaded)}};var a="\\s*([+-]?\\d+)\\s*",h="\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)\\s*",c="\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)%\\s*",p=new RegExp("^rgb\\("+[a,a,a]+"\\)$"),d=new RegExp("^rgb\\("+[c,c,c]+"\\)$"),f=new RegExp("^rgba\\("+[a,a,a,h]+"\\)$"),u=new RegExp("^rgba\\("+[c,c,c,h]+"\\)$"),l=new RegExp("^hsl\\("+[h,c,c]+"\\)$"),g=new RegExp("^hsla\\("+[h,c,c,h]+"\\)$"),m=function(t,e,o,i){return{c:t/255+" "+e/255+" "+o/255,a:i}},y=function(t){if(!t)return{c:"0 0 0",a:1};if(!t.toString().startsWith("rgb")&&!t.toString().startsWith("hsl")){var e=document.createElement("div");e.style.color=t,document.body.appendChild(e),t=window.getComputedStyle(e).color+"",document.body.removeChild(e)}var o,i=((t=t.replace(/\s/g,""))+"").trim().toLowerCase();return(o=p.exec(i))?m(o[1],o[2],o[3],1):(o=d.exec(i))?m(255*o[1]/100,255*o[2]/100,255*o[3]/100,1):(o=f.exec(i))?m(o[1],o[2],o[3],o[4]):(o=u.exec(i))?m(255*o[1]/100,255*o[2]/100,255*o[3]/100,o[4]):(o=l.exec(i))?r(o[1],o[2]/100,o[3]/100):(o=g.exec(i))?r(o[1],o[2]/100,o[3]/100,o[4]):{c:t,a:1}};
/*
	@license MIT LICENSE
	Copyright (c) 2014 Devon Govett

	Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

	The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
	*/function x(){this.objects=[],this.catalog=this.add(new P),this.pages=this.add(new b),this.catalog.setPages(this.pages),this.pageWidth=8.27,this.pageHeight=11.69,this.textStyle=new M,this.fonts=[],this.lineWidth=1,this.lineEndType=0,this.alpha=1,e.useFlateDecode=!!window.pako||!!window.fflate,e.deflate=function(t){var e=t;if(window.pako)return window.pako.deflate(e);if(window.fflate){if("string"==typeof e)e=(new TextEncoder).encode(e);return window.fflate.zlibSync(e)}return e}}function P(){}function b(){this.pages=[]}function C(t,e,o,i){this.pdf=t,this.fonts=[],this.images=[],this.fillImages=[],this.alphas=[],this.fillColor="0 0 0 ",this.strokeColor="0 0 0 ",this.lineWidth=2,this.lineCap=0,this.lineJoin=1,this.fontSize=12,this.font="normal",this.width=72*e,this.height=72*o,this.parentPagesList=i,this._ctm=[1,0,0,1,0,0]}function v(t){const e=t.unicodes.map(((t,e)=>`<${O.toHex(e)}><${O.toHex(t)}>`)).join("\n");this.stream=`/CIDInit /ProcSet findresource begin\n                       10 dict begin\n                       begincmap\n                       /CIDSystemInfo\n                       << /Registry (Adobe)\n                       /Ordering (UCS)\n                       /Supplement 0\n                       >> def\n                       /CMapName /Adobe-Identity-UCS def\n                       /CMapType 2 def\n                       1 begincodespacerange\n                       <0000> <FFFF>\n                       endcodespacerange\n                       ${t.unicodes.length} beginbfchar\n                       ${e}\n                       endbfchar\n                       endcmap\n                       CMapName currentdict /CMap defineresource pop\n                       end\n                       end`}function T(){}function S(){}function w(t){this.buffer=atob(t.base64)}function F(t){this.fontName=t,this.descendantFonts=[],this.subtype="Type1",this.encoding="WinAnsiEncoding"}function I(){this.stream=""}e.PdfContext=function(t,e,o){var i=this,n=new x;this.doc=n;var r=document.createElement("canvas");this.context=r.getContext("2d"),n.pageSetWidth(t/72),n.pageSetHeight(e/72),n.addPage(o);var s="10px Helvetica";this.textAlign="left",this.textBaseline="alphabetic";Object.defineProperty(this,"fillStyle",{get:function(){return this.fillColor},set:function(t){if(this.fillColor=t,t instanceof k)console.log("TODO",i.doc);else if(t.toString().startsWith("rgb")||t.toString().startsWith("hsl")){var e=y(t);i.doc.fillColor(e.c,e.a)}}}),Object.defineProperty(this,"strokeStyle",{get:function(){return i.doc.strokeColor()},set:function(t){var e=y(t);i.doc.strokeColor(e.c,e.a)}}),Object.defineProperty(this,"lineWidth",{get:function(){return i.doc.setLineWidth()},set:function(t){i.doc.setLineWidth(t)}}),Object.defineProperty(this,"lineCap",{get:function(){return"butt"},set:function(t){i.doc.lineCap(t)}}),Object.defineProperty(this,"lineJoin",{get:function(){return"miter"},set:function(t){i.doc.lineJoin(t)}}),Object.defineProperty(this,"miterLimit",{get:function(){return 10},set:function(){}}),Object.defineProperty(this,"globalAlpha",{get:function(){return i.doc.opacity()},set:function(t){i.doc.opacity(t)}}),Object.defineProperty(this,"font",{get:function(){return s},set:function(t){this.context.font=t,s=t;var e,o,n=((o=(e=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-_,\'\"\sa-z0-9]+?)\s*$/i).exec(i.font))||(console.log("error parsing font "+i.font),o=e.exec("10px Helvetica")),o[6].indexOf("sans-serif")>-1&&(o[6]="Helvetica"),o[6].indexOf("serif")>-1&&(o[6]="Times-Roman"),{style:o[1]||"normal",size:parseInt(o[4])||10,family:o[6]||"Helvetica",weight:o[3]||"normal"});i.doc.fontSize(n.size),i.doc.font(n.family),i.doc.setFontStyle("normal"!=n.weight,"normal"!=n.style,!1)}}),this.font=s,this.strokeStyle="rgb(0,0,0)",this.fillStyle="rgb(0,0,0)"},e.PdfContext.prototype.end=function(){this.doc.end()},e.PdfContext.prototype.addPage=function(t){this.doc.addPage(t)},e.PdfContext.prototype.removePage=function(){this.doc.removePage()},e.PdfContext.prototype.save=function(){this.doc.save()},e.PdfContext.prototype.restore=function(){this.doc.restore()},e.PdfContext.prototype.transform=function(t,e,o,i,n,r){this.doc.transform(t,e,o,i,n,r)},e.PdfContext.prototype.scale=function(t,e){this.doc.scale(t,e)},e.PdfContext.prototype.rotate=function(t){var e=180*t/Math.PI;this.doc.rotate(e)},e.PdfContext.prototype.translate=function(t,e){this.doc.translate(t,e)},e.PdfContext.prototype.beginPath=function(){this.doc.beginPath()},e.PdfContext.prototype.moveTo=function(t,e){this.doc.moveTo(t,e)},e.PdfContext.prototype.closePath=function(){this.doc.closePath()},e.PdfContext.prototype.lineTo=function(t,e){this.doc.lineTo(t,e)},e.PdfContext.prototype.stroke=function(){this.doc.stroke()},e.PdfContext.prototype.fill=function(t){this.doc.fill(t)},e.PdfContext.prototype.rect=function(t,e,o,i){this.doc.rect(t,e,o,i)},e.PdfContext.prototype.fillRect=function(t,e,o,i){this.doc.beginPath(),this.doc.rect(t,e,o,i),this.doc.fill()},e.PdfContext.prototype.strokeRect=function(t,e,o,i){this.doc.beginPath(),this.doc.rect(t,e,o,i),this.doc.stroke()},e.PdfContext.prototype.clearRect=function(t,e,o,i){var n=this.doc.fillColor();this.doc.fillColor("white"),this.doc.rect(t,e,o,i),this.doc.fill(),this.doc.fillColor(n)},e.PdfContext.prototype.arc=function(t,e,o,i,n,r){this.doc.arc(t,e,o,i,n,r)},e.PdfContext.prototype.bezierCurveTo=function(t,e,o,i,n,r){this.doc.bezierCurveTo(t,e,o,i,n,r)},e.PdfContext.prototype.quadraticCurveTo=function(t,e,o,i){this.doc.quadraticCurveTo(t,e,o,i)},e.PdfContext.prototype.createLinearGradient=function(t,e,o,i){return this.doc.linearGradient(t,e,o,i)},e.PdfContext.prototype.createRadialGradient=function(t,e,o,i,n,r){var s=this.doc.radialGradient(t,e,o,i,n,r);return s.addColorStop=function(t,e){var o=y(e);s.stop(t,o.c,o.a)},s},e.PdfContext.prototype.fillText=function(t,e,o){t&&t.trim().length&&this.doc.textAdd(e,o,t)},e.PdfContext.prototype.strokeText=function(){console.log("strokeText not implemented, use fillText")},e.PdfContext.prototype.measureText=function(t){return this.context.measureText(t+"")},e.PdfContext.prototype.clip=function(){this.doc.clip()},e.PdfContext.prototype.getPDFbase64=function(){return this.doc.getBase64Text()},e.PdfContext.prototype.getPDFtext=function(){return this.doc.getText()},e.PdfContext.prototype.drawImage=function(t,e,o,i,n){var r=this.doc.currentPage._ctm,s=r[0]*r[3]-r[1]*r[2];return this.doc.drawImage(t,e,o,i,n,Math.sqrt(Math.abs(s)))},e.PdfContext.prototype.setLineDash=function(t){return this.doc.setLineDash(t)},e.PdfContext.prototype.createPattern=function(t){var e=this.doc.imageTileLoad(t);return{setTransform:t=>{e.matrix=t}}},e.PdfContext.prototype.setTransform=function(){console.log("setTransform not implemented")},e.PdfContext.prototype.drawFocusRing=function(){console.log("drawFocusRing not implemented")},e.PdfContext.prototype.createImageData=function(){console.log("drawFocusRing not implemented")},e.PdfContext.prototype.getImageData=function(){console.log("getImageData not implemented")},e.PdfContext.prototype.putImageData=function(){console.log("putImageData not implemented")},e.PdfContext.prototype.globalCompositeOperation=function(){console.log("globalCompositeOperation not implemented")},e.PdfContext.prototype.arcTo=function(){console.log("arcTo not implemented")},x.prototype.add=function(t){return this.objects.push(t),t.id=this.objects.length,t},x.prototype.pageSetWidth=function(t){this.pageWidth=t},x.prototype.pageSetHeight=function(t){this.pageHeight=t},x.prototype.addPage=function(t){this.currentPage=new C(this,this.pageWidth,this.pageHeight,this.pages),this.currentPage.dpi=t?.dpi||72,this.add(this.currentPage),this.pages.addPage(this.currentPage);var e=new I;this.add(e),this.currentPage.setStream(e),t&&t.verticalFlip||this.currentPage.transform(1,0,0,-1,0,this.currentPage.height)},x.prototype.removePage=function(){this.pages.removePage()},x.prototype.font=function(t){this.currentPage.setFontName(t)},x.prototype.fontSize=function(t){this.currentPage.setFontSize(t)},x.prototype.lineJoin=function(t){this.currentPage.setLineJoin(t)},x.prototype.lineCap=function(t){this.currentPage.setLineCap(t)},x.prototype.setLineWidth=function(t){this.currentPage.setLineWidth(t)},x.prototype.strokeColor=function(t,e){this.currentPage.setStrokeColor(t,e)},x.prototype.fillColor=function(t,e){this.currentPage.setFillColor(t,e)},x.prototype.pageSetCurrent=function(t){this.currentPage=t},x.prototype.font=function(t){this.textStyle.setFontName(t)},x.prototype.fontSetSize=function(t){this.textStyle.fontSetSize(t)},x.prototype.setFontStyle=function(t,e){this.textStyle.setFontStyle(t,e)},x.prototype.setFont=function(t){var n=t.getFontName();if(null!=n){var r,s=null;for(r=0;r<this.fonts.length;r++)this.fonts[r].fontName==n&&(s=this.fonts[r]);if(null==s){if(!i[n]&&n.startsWith("Roboto")){o.add(n);const t=document.createElement("script");throw t.src=e.fontPath+n.split("-")[0]+".js",document.head.append(t),new Error("Font not loaded: "+n)}if(s=new F(n),this.add(s),this.fonts.push(s),n.startsWith("Roboto")){s.subtype="Type0";const t=this.add(new F("Unicode"));s.baseFont="Unicode",s.spec=t.spec=i[n],t.subtype="CIDFontType2",t.cidToGidMap="Identity",this.fonts.push(t),s.descendantFonts.push(t),s.encoding="Identity-H",s.toUnicode=this.add(new v(s.spec)),t.fontDescriptor=this.add(new S),t.fontDescriptor.spec=s.spec,t.systemInfo=this.add(new T),t.fontDescriptor.fontFile=this.add(new w(s.spec))}}t.setFont(s)}},x.prototype.textAdd=function(t,e,o){var i=this.textStyle.clone();(this.currentPage.isUnicode||[...o].find((t=>t.charCodeAt(0)>127)))&&(i.setFontName(i.fontName.startsWith("Times")?"RobotoSerif":"Roboto"),this.currentPage.isUnicode=!0),this.setFont(i),this.currentPage.textAdd(t,e,o,i)},x.prototype.imageLoadFromCanvas=function(t,e){(t=new R(t)).scale=e,this.add(t),t.mask&&this.add(t.mask),this.currentImage=t},x.prototype.imageTileLoadFromCanvas=function(t){return(t=new L(t,this.currentPage.fillColor,1*this.currentPage.alpha)).vectorPattern&&this.add(t.vectorPattern),this.add(t),this.currentPage.currentImageTile=t,t},x.prototype.linearGradient=function(t,e,o,i){var n=new k(t,e,o,i,this.currentPage);return this.add(n),this.currentPage.currentImageTile=n,this.addPatternToPage(n),n},x.prototype.doDrawImage=function(t,e,o,i){this.currentPage.drawImage(t,e,this.currentImage,this.alpha,o,i)},x.prototype.addPatternToPage=function(t){this.currentPage.addPatternToPage(t)},x.prototype.moveTo=function(t,e){this.currentPage.moveTo(t,e)},x.prototype.lineTo=function(t,e){this.currentPage.lineTo(t,e)},x.prototype.bezierCurveTo=function(t,e,o,i,n,r){this.currentPage.bezierCurveTo(t,e,o,i,n,r)},x.prototype.translate=function(t,e){this.currentPage.translate(t,e)},x.prototype.transform=function(t,e,o,i,n,r){this.currentPage.transform(t,e,o,i,n,r)},x.prototype.drawImage=function(t,e,o,i,n,r){var s=1;if("img"==t.nodeName.toLowerCase()){var a=document.createElement("canvas");t.src.startsWith&&t.src.startsWith("data:image/svg")&&(s=2*Math.max(1,r||1)*this.currentPage.dpi/72),a.width=t.width*s,a.height=t.height*s,a.getContext("2d").drawImage(t,0,0,t.width,t.height,0,0,a.width,a.height),t=a}this.imageLoadFromCanvas(t,s),this.doDrawImage(e,o,t.width,t.height)},x.prototype.imageTileLoad=function(t){if(t.nodeName&&"img"==t.nodeName.toLowerCase()){var e=document.createElement("canvas");e.width=t.width,e.height=t.height,e.getContext("2d").drawImage(t,0,0),t=e}var o=this.imageTileLoadFromCanvas(t);return this.addPatternToPage(this.currentPage.currentImageTile),o},x.prototype.scale=function(t,e,o){this.currentPage.scale(t,e,o)},x.prototype.rotate=function(t,e){this.currentPage.rotate(t,e)},x.prototype.beginPath=function(){this.currentPage.beginPath()},x.prototype.arc=function(t,e,o,i,n,r){this.currentPage.arc(t,e,o,i,n,r)},x.prototype.closePath=function(){this.currentPage.closePath()},x.prototype.stroke=function(){this.currentPage.stroke()},x.prototype.clip=function(t){this.currentPage.clip(t)},x.prototype.opacity=function(t){if(void 0===t)return this.currentPage.currentAlpha;this.currentPage.setAlpha(t)},x.prototype.setLineDash=function(t){this.currentPage.setLineDash(t)},x.prototype.save=function(){this.currentPage.saveContext()},x.prototype.restore=function(){this.currentPage.restoreContext()},x.prototype.fill=function(t){this.currentPage.fill(t)},x.prototype.rect=function(t,e,o,i){this.currentPage.rect(t,e,o,i)},x.prototype.quadraticCurveTo=function(t,e,o,i){this.currentPage.quadraticCurveTo(t,e,o,i)},x.prototype.graphicsSetAlpha=function(t){this.alpha=Math.floor(100*t/255)/100,this.textStyle.setAlpha(t)},x.prototype.graphicsSetLineEndType=function(t){this.lineEndType=t},x.prototype._write=function(t){this.stream+=t+"\n"},x.prototype.getObject=function(t){var e,o;for(this.stream="",this._write("%PDF-1.7"),e=0;e<this.objects.length;e++)(o=this.objects[e]).offset=this.stream.length,o=o.getObject(this,t),this._write(o);t=this.stream.length,this._write("xref"),this._write("0 "+(this.objects.length+1)),this._write("0000000000 65535 f");var i=this.objects;for(e=0;e<i.length;e++){var n=this.objects[e].offset;n=("0000000000"+n).slice(-10),this._write(n+" 00000 n")}return this._write("trailer"),this._write(O.convert({Size:this.objects.length+1,Root:j.of(this.catalog)})),this._write("startxref"),this._write(t),this._write("%%EOF"),this.stream},x.prototype.getBase64Text=function(){return"data:application/pdf;base64,"+btoa(this.getObject(this))},P.prototype.setPages=function(t){this.props={Type:"Catalog",Pages:j.of(t)}},P.prototype.getObject=function(){return O.makeObject(this.props,this.id)},b.prototype.addPage=function(t){return this.pages.push(t),t.setPageNumber(this.pages.length),t},b.prototype.removePage=function(){this.pages.splice(-1)},b.prototype.getObject=function(){for(var t="[",e=0;e<this.pages.length;e++)t+=this.pages[e].id,t+=" 0 R ";t+="]";var o={Type:"Pages",Count:this.pages.length,Kids:new j(t)};return O.makeObject(o,this.id)},C.prototype.setStream=function(t){this.pdfStream=t},C.prototype.setPageNumber=function(t){this.pageNumber=t},C.prototype.textAdd=function(t,e,o,i){var n=this.fontSize;-1==this.fonts.indexOf(i.font)&&this.fonts.push(i.font),o=O.convert(new String(o),i.font.spec),this.setAlpha(i.alpha),e=this.height-e,this.saveContext(),this.transform(1,0,0,-1,0,this.height),this.pdfStream.addText("BT "+this.strokeColor+" rg /F"+i.font.id+" "+n+" Tf 1 0 0 1 "+t+" "+e+" cm "+o+"Tj ET "),this.restoreContext()},C.prototype.setAlpha=function(t){var e=1*t;if(this.currentAlpha!=e){-1==this.alphas.indexOf(e)&&this.alphas.push(e);var o=this.alphas.indexOf(e);this.pdfStream.addText("/Alpha"+o+" gs "),this.currentAlpha=e}},C.prototype.moveTo=function(t,e){this.pdfStream.addText(t+" "+e+" m ")},C.prototype.setLineWidth=function(t){this.lineWidth=t},C.prototype.lineTo=function(t,e){this.pdfStream.addText(t+" "+e+" l ")},C.prototype.bezierCurveTo=function(t,e,o,i,n,r){this.pdfStream.addText(t+" "+e+" "+o+" "+i+" "+n+" "+r+" c ")},C.prototype.transform=function(t,e,o,i,n,r){var s,a,h,c,p,d,f,u,l;a=(s=this._ctm)[0],h=s[1],c=s[2],p=s[3],d=s[4],f=s[5],s[0]=a*t+c*e,s[1]=h*t+p*e,s[2]=a*o+c*i,s[3]=h*o+p*i,s[4]=a*n+c*r+d,s[5]=h*n+p*r+f,l=function(){var s,a,h,c;for(c=[],s=0,a=(h=[t,e,o,i,n,r]).length;s<a;s++)u=h[s],c.push(+u.toFixed(5));return c}().join(" "),this.pdfStream.addText(l+" cm ")},C.prototype.translate=function(t,e){this.transform(1,0,0,1,t,e)},C.prototype.rotate=function(t,e){var o,i,n,r,s,a,h;null==e&&(e={}),i=t*Math.PI/180,o=Math.cos(i),n=Math.sin(i),r=s=0,null!=e.origin&&(a=(r=(h=e.origin)[0])*n+(s=h[1])*o,r-=r*o-s*n,s-=a),this.transform(o,n,-n,o,r,s)},C.prototype.scale=function(t,e,o){var i,n,r;null==e&&(e=t),null==o&&(o={}),i=n=0,null!=o.origin&&(i=(r=o.origin)[0],n=r[1],i-=t*i,n-=e*n),this.transform(t,0,0,e,i,n)},C.prototype.stroke=function(){this.pdfStream.addTextCheckMerge("S ")},C.prototype.clip=function(t){this.pdfStream.addText((/even-?odd/.test(t)?"W* ":"W ")+" n ")},C.prototype.setLineDash=function(t){this.lineDash=t},C.prototype.saveContext=function(){this.pdfStream.addText("q ")},C.prototype.restoreContext=function(){this.pdfStream.addText("Q "),this.currentAlpha=void 0},C.prototype.fill=function(t){this.currentImageTile&&(this.setAlpha(1),this.pdfStream.addText("/Pattern cs "),this.pdfStream.addText("/Pattern CS "),this.pdfStream.addText("/Paint"+this.currentImageTile.id+" scn "),this.pdfStream.addText("/Paint"+this.currentImageTile.id+" SCN "),this.currentImageTile=void 0),this.pdfStream.addTextCheckMerge(/even-?odd/.test(t)?"f* ":"f ")},C.prototype.beginPath=function(){if(this.lineDash&&this.lineDash.length){this.pdfStream.addText("[");for(var t=0;t<this.lineDash.length;t++)this.pdfStream.addText(this.lineDash[t]),this.pdfStream.addText(" ");this.pdfStream.addText("] 0 d "),this.currentDashLength=this.lineDash.length}else this.currentDashLength&&(this.pdfStream.addText("[] 0 d "),this.currentDashLength=0);this.setAlpha(this.alpha),this.pdfStream.addText(this.fillColor+" rg "),this.pdfStream.addText(this.strokeColor+" RG "),this.pdfStream.addText(this.lineCap+" J "+this.lineJoin+" j "+(1|this.lineWidth)+" w ")},C.prototype.setStrokeColor=function(t,e){this.strokeColor=t||"0 0 0",this.alpha=e},C.prototype.setFillColor=function(t,e){this.fillColor=t||"0 0 0",this.alpha=e},C.prototype.closePath=function(){this.pdfStream.addText("h ")},C.prototype.quadraticCurveTo=function(t,e,o,i){return this.pdfStream.addText(t+" "+e+" "+o+" "+i+" v ")},C.prototype._bezierCurve=function(t,e,o,i,n,r){var s=Math.PI,a=o,h=i,c=Math.cos(n*s/180),p=Math.sin(n*s/180),d=Math.cos((n+r)*s/180),f=Math.sin((n+r)*s/180),u=t+a*c,l=e-h*p,g=-a*p,m=-h*c,y=t+a*d,x=e-h*f,P=-a*f,b=-h*d,C=Math.tan(r/2*s/180),v=Math.sin(r*s/180)*(Math.sqrt(4+3*C*C)-1)/3;return[u,l,u+v*g,l+v*m,y-v*P,x-v*b,y,x]},C.prototype.arc=function(t,e,o,i,n,r){r&&console.log("Counterclockwise not supported"),i*=180/Math.PI,n*=180/Math.PI;for(var s=o-1,a=o-1,h=Math.ceil(Math.abs(n/45)),c=i,p=n/h,d=0;d<h;d++){var f=this._bezierCurve(t,e,s,a,c,p);0==d&&this.moveTo(f[0],f[1]),this.bezierCurveTo(f[2],f[3],f[4],f[5],f[6],f[7]),c+=p}},C.prototype.rect=function(t,e,o,i){var n=t+o,r=e+i;this.pdfStream.addText(t+" "+e+" m "+n+" "+e+" l "+n+" "+r+" l "+t+" "+r+" l "+t+" "+e+" l ")},C.prototype._CAP_STYLES={BUTT:0,ROUND:1,SQUARE:2},C.prototype.setLineCap=function(t){"string"==typeof t&&(t=this._CAP_STYLES[t.toUpperCase()]),this.lineCap=t},C.prototype._JOIN_STYLES={MITER:0,ROUND:1,BEVEL:2},C.prototype.setLineJoin=function(t){"string"==typeof t&&(t=this._JOIN_STYLES[t.toUpperCase()]),this.lineJoin=t},C.prototype.setFontSize=function(t){this.fontSize=t},C.prototype.transform=function(t,e,o,i,n,r){var s,a,h,c,p,d,f,u,l;a=(s=this._ctm)[0],h=s[1],c=s[2],p=s[3],d=s[4],f=s[5],s[0]=a*t+c*e,s[1]=h*t+p*e,s[2]=a*o+c*i,s[3]=h*o+p*i,s[4]=a*n+c*r+d,s[5]=h*n+p*r+f,l=function(){var s,a,h,c;for(c=[],s=0,a=(h=[t,e,o,i,n,r]).length;s<a;s++)u=h[s],c.push(+u.toFixed(5));return c}().join(" "),this.pdfStream.addText(l+" cm ")},C.prototype.drawImage=function(t,e,o,i,n,r){var s=o.scale||1;this.saveContext(),this.transform(1,0,0,-1,0,0),this.translate(t,-r/s-e),this.scale(n/s,r/s),this.pdfStream.addText("/Image"+o.id+" Do "),this.restoreContext(),-1==this.images.indexOf(o)&&this.images.push(o)},C.prototype.addPatternToPage=function(t){-1==this.fillImages.indexOf(t)&&this.fillImages.push(t)},C.prototype.getObject=function(t){t.pageSetCurrent(this);var e={Type:"Page"};e.Parent=j.of(this.parentPagesList),e.MediaBox=[0,0,this.width,this.height],e.Contents=j.of(this.pdfStream);var o={};if(this.fonts.length>0)for(var i=0;i<this.fonts.length;i++){var n=this.fonts[i];o["F"+n.id]=j.of(n)}var r={};if(this.alphas.length>0)for(i=0;i<this.alphas.length;i++){var s=this.alphas[i];(isNaN(s)||void 0===s)&&(s="1"),"string"==typeof s&&(s*=1),r["Alpha"+i]={CA:s,ca:s}}var a={};if(this.images.length>0)for(var h=0;h<this.images.length;h++)a["Image"+(n=this.images[h]).id]=j.of(n);var c={};if(this.fillImages.length>0)for(h=0;h<this.fillImages.length;h++)c["Paint"+(n=this.fillImages[h]).id]=j.of(n);return e.Resources={},this.fonts.length>0&&(e.Resources.Font=o),this.alphas.length>0&&(e.Resources.ExtGState=r),this.fillImages.length>0&&(e.Resources.Pattern=c),this.images.length>0&&(e.Resources.XObject=a),O.makeObject(e,this.id)},v.prototype.getObject=function(){var t=D(this.stream),e={Length:t.length};return O.makeObject(e,this.id,t)},T.prototype.getObject=function(){const t={Supplement:0,Registry:new j("(Adobe)"),Ordering:new j("(Identity)")};return O.makeObject(t,this.id)},S.prototype.getObject=function(){const t={CapHeight:939,StemV:56,FontBBox:this.spec.bbox,FontFile2:j.of(this.fontFile),Descent:this.spec.bbox[2],Type:"FontDescriptor",Flags:32,FontName:"Unicode",ItalicAngle:0,Ascent:this.spec.bbox[3]};return O.makeObject(t,this.id)},w.prototype.getObject=function(){const t={Length:this.buffer.length,Length1:this.buffer.length};return O.makeObject(t,this.id,this.buffer)},F.TIMES=["Times-Roman","Times-Italic","Times-Bold","Times-BoldItalic"],F.HELVETICA=["Helvetica","Helvetica-Oblique","Helvetica-Bold","Helvetica-BoldOblique"],F.ROBOTO=["Roboto-Regular","Roboto-Italic","Roboto-Bold","Roboto-BoldItalic"],F.ROBOTO_SERIF=["RobotoSerif-Regular","RobotoSerif-Italic","RobotoSerif-Bold","RobotoSerif-BoldItalic"],F.getPDFName=function(t,e,o){var i=(e?2:0)+(o?1:0);return"Helvetica"==t?F.HELVETICA[i]:"Roboto"==t?F.ROBOTO[i]:"RobotoSerif"==t?F.ROBOTO_SERIF[i]:F.TIMES[i]},F.prototype.getObject=function(){var t={Subtype:this.subtype,Name:"F"+this.id,BaseFont:this.baseFont||this.fontName,Encoding:this.encoding,Type:"Font",DescendantFonts:this.descendantFonts.map((t=>j.of(t)))};if(this.toUnicode&&(t.ToUnicode=j.of(this.toUnicode)),this.systemInfo&&(t.CIDSystemInfo=j.of(this.systemInfo)),this.fontDescriptor&&(t.FontDescriptor=j.of(this.fontDescriptor)),this.cidToGidMap){t.FontMatrix=this.spec.matrix,t.FontBBox=this.spec.bbox;const e=this.spec.matrix[0]/.001;t.W=new j("["+this.spec.widths.map(((t,o)=>t&&o?`${o} [${Math.round(t*e)}]`:"")).join("")+"]"),t.CIDToGIDMap=this.cidToGidMap}return O.makeObject(t,this.id)},I.prototype.addText=function(t){this.stream+=t},I.prototype.addTextCheckMerge=function(t){function e(t,e){return-1!==t.indexOf(e,t.length-e.length)}"f* "==t&&e(this.stream," S ")?this.stream=this.stream.substring(0,this.stream.length-3)+" B* ":"S "==t&&e(this.stream," f* ")?this.stream=this.stream.substring(0,this.stream.length-4)+" B* ":"f "==t&&e(this.stream," S ")||"S "==t&&e(this.stream," f ")?this.stream=this.stream.substring(0,this.stream.length-3)+" B ":this.stream+=t},I.prototype.replaceText=function(t,e){this.stream=this.stream.replace(t,e)},I.prototype.getObject=function(){var t=D(this.stream),o={Length:t.length};return e.useFlateDecode&&(o.Filter="FlateDecode"),O.makeObject(o,this.id,t)};var O,j,D=function(t){if(e.useFlateDecode)t=e.deflate(t);else if("string"==typeof t)return t;for(var o=[],i=0;i<t.length;i++)o.push(String.fromCharCode(t[i]));return o.join("")};function R(t,e){this.width=t.width,this.height=t.height,this.isMask=!!e,e?this.stream=D(e):this.loadData(t)}function k(t,e,o,i,n){this.page=n,this.x1=t,this.y1=e,this.x2=o,this.y2=i,this.cols=["white","black"]}function B(t,e){this.stream=t,this.boundingBox=e}function L(t,o,i){if(t.getContext){this.width=t.width,this.height=t.height,this.boundingBox=[0,0,this.width,this.height];for(var n=[this.width+" 0.0000 0.0000 -"+this.height+" 0.0000 "+this.height+" cm ","BI ","/Width "+this.width+" ","/Height "+this.height+" ","/ColorSpace /DeviceRGB ","/BitsPerComponent 8 "],r=t.getContext("2d").getImageData(0,0,this.width,this.height),s=o.split(" ").map((t=>t*(1-i)+i)),a=new Uint8Array(this.width*this.height*3),h=0,c=this.height-1;c>=0;c--)for(var p=0;p<this.width;p++){var d=r.data[4*(p+c*this.width)],f=r.data[4*(p+c*this.width)+1],u=r.data[4*(p+c*this.width)+2],l=r.data[4*(p+c*this.width)+3];[d,f,u]=[d,f,u].map(((t,e)=>Math.round(parseFloat(t)/255*l+s[e]*(255-l)))),a[h++]=d,a[h++]=f,a[h++]=u}e.useFlateDecode&&n.push("/Filter /FlateDecode "),this.stream=n.join("")+"ID\n"+D(a)+"\nEI\n"}else{var g=t.doc.currentPage;this.boundingBox=t.boundingBox||[0,0,72*g.pdf.pageWidth,72*g.pdf.pageHeight],this.alphas=g.alphas,this.vectorPattern=new B(g.pdfStream.stream,this.boundingBox)}}function M(){this.fontName="Helvetica",this.fontSize=12,this.italic=!1,this.bold=!1,this.font=void 0,this.alpha=1}R.prototype.loadData=function(t){for(var e=t.getContext("2d"),o=new Uint8Array(this.height*this.width*3),i=e.getImageData(0,0,this.width,this.height),n=0,r=new Uint8Array(this.height*this.width),s=0,a=!1,h=0;h<this.height;h++)for(var c=0;c<this.width;c++){var p=i.data[4*(c+h*this.width)],d=i.data[4*(c+h*this.width)+1],f=i.data[4*(c+h*this.width)+2],u=i.data[4*(c+h*this.width)+3];o[n++]=p,o[n++]=d,o[n++]=f,r[s++]=u,255!=u&&(a=!0)}a&&(this.mask=new R(t,r)),this.stream=D(o)},R.prototype.writeImage=function(t){this.stream=t},R.prototype.getObject=function(){var t={Type:"XObject",Width:this.width,Height:this.height,Subtype:"Image",ColorSpace:this.isMask?"DeviceGray":"DeviceRGB",BitsPerComponent:8,Name:"Image"+this.id,Length:this.stream.length};return this.mask&&(t.SMask=j.of(this.mask)),e.useFlateDecode&&(t.Filter="FlateDecode"),O.makeObject(t,this.id,this.stream)},k.prototype.addColorStop=function(t,e){0!=t&&1!=t&&console.error("only 0 and 1 supported for addColorStop",t),this.cols[Math.round(t)]=e},k.prototype.getObject=function(){var t=y(this.cols[0]).c.split(" "),e=y(this.cols[1]).c.split(" "),o={Type:"Pattern",PatternType:2,Shading:{ShadingType:2,Extend:[!0,!0],Coords:[this.x1,this.page.height-this.y1,this.x2,this.page.height-this.y2],ColorSpace:"DeviceRGB",Function:{FunctionType:2,N:1,Domain:[0,1],C0:[1*t[0],1*t[1],1*t[2]],C1:[1*e[0],1*e[1],1*e[2]]}}};return O.makeObject(o,this.id,this.stream)},B.prototype.getObject=function(){var t={Type:"XObject",Subtype:"Form",BBox:this.boundingBox};return O.makeObject(t,this.id,this.stream)},L.prototype.writeImage=function(t){this.stream=t},L.prototype.getObject=function(){var t={},e=[this.matrix?this.matrix.m11:1,0,0,this.matrix?this.matrix.m22:1,0,0];this.vectorPattern&&(this.stream=`/x${this.vectorPattern.id} Do`,t[`x${this.vectorPattern.id}`]=j.of(this.vectorPattern),e=[1,0,0,-1,0,0]);var o={Type:"Pattern",PatternType:1,PaintType:1,TilingType:1,BBox:this.boundingBox,XStep:this.boundingBox[2]-this.boundingBox[0],YStep:this.boundingBox[3]-this.boundingBox[1],Length:this.stream.length,Matrix:e,Resources:this.vectorPattern?{XObject:t}:{ProcSet:["PDF","ImageC"]}};return O.makeObject(o,this.id,this.stream)},M.prototype.setFontName=function(t){this.fontName=t,this.font=void 0},M.prototype.fontSetSize=function(t){this.fontSize=t},M.prototype.setFontStyle=function(t,e){this.bold=t,this.italic=e},M.prototype.setColor=function(t){this.color=t},M.prototype.setAlpha=function(t){this.alpha=t},M.prototype.getFontName=function(){return F.getPDFName(this.fontName,this.bold,this.italic)},M.prototype.setFont=function(t){this.font=t},M.prototype.clone=function(){var t=new M;return t.fontName=this.fontName,t.fontSize=this.fontSize,t.bold=this.bold,t.italic=this.italic,t.color=this.color,t.alpha=this.alpha,t.font=this.font,t},O=function(){var t,e,o;function i(){}return o=function(t,e){return(Array(e+1).join("0")+t).slice(-e)},e=/[\n\r\t\b\f()\\]/g,t={"\n":"\\n","\r":"\\r","\t":"\\t","\b":"\\b","\f":"\\f","\\":"\\\\","(":"\\(",")":"\\)"},i.makeObject=function(t,e,o){var n=e+" 0 obj\n"+i.convert(t);return o&&(n+="\nstream\n"+o+"\nendstream\n"),n+="endobj\n"},i.toHex=function(t){return t.toString(16).padStart(4,"0")},i.fromUnicode=function(t,e){const o=e.unicodes.indexOf(t);return o<=0?e.unicodes.indexOf(63):o},i.convert=function(n,r){var s,a,h,c,p,d,f,u;if("string"==typeof n)return"/"+n;if(n instanceof String){p=n;if(!!r||[...p].find((t=>t.charCodeAt(0)>127))){var l="";for(a=f=0,u=p.length;f<u;a=f+=1){l+=i.toHex(i.fromUnicode(p.codePointAt(a),r))}return"<"+l+">"}return"("+(p=n.replace(e,(function(e){return t[e]})))+")"}if(n instanceof j)return n.toString();if(n instanceof Date)return"(D:"+o(n.getUTCFullYear(),4)+o(n.getUTCMonth()+1,2)+o(n.getUTCDate(),2)+o(n.getUTCHours(),2)+o(n.getUTCMinutes(),2)+o(n.getUTCSeconds(),2)+"Z)";if(Array.isArray(n))return"["+function(){var t,e,o;for(o=[],t=0,e=n.length;t<e;t++)s=n[t],o.push(i.convert(s));return o}().join(" ")+"]";if("[object Object]"==={}.toString.call(n)){for(h in c=["<<"],n)d=n[h],c.push("/"+h+" "+i.convert(d)+"\n");return c.push(">>"),c.join("")+"\n"}return""+n},i}(),j=function(){function t(t){this.str=t}return t.prototype.toString=function(){return this.str},t.of=function(e){return new t(e.id+" 0 R")},t}()}("undefined"!=typeof window?window:this);